%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% mfile to solve of "Integrated design for interconnected systems with actuator faults"
% Jianglin Lan, 31/01/2016, function file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sys_state = FTC_Closed_sys_performance_f(t,xx,A1,B1,C1,F1,A2,B2,C2,F2,A3,B3,C3,F3,Kx1,Kf1,G1,M1,L1,H1,Kx2,Kf2,G2,M2,L2,H2,Kx3,Kf3,G3,M3,L3,H3)
z11 = xx(1);
z12 = xx(2);
z13 = xx(3);
z14 = xx(4);
z15 = xx(5);
z21 = xx(6);
z22 = xx(7);
z23 = xx(8);
z24 = xx(9);
z25 = xx(10);
z31 = xx(11);
z32 = xx(12);
z33 = xx(13);
z34 = xx(14);
z35 = xx(15);

x11 = xx(16);
x12 = xx(17);
x13 = xx(18);
x14 = xx(19); 
x21 = xx(20);
x22 = xx(21);
x23 = xx(22);
x24 = xx(23);
x31 = xx(24);
x32 = xx(25);
x33 = xx(26);
x34 = xx(27);

global ff1 ff2 ff3 hat_ff1 hat_ff2 hat_ff3 Int_ts Int_count Int_tmp 
global hat_x11 hat_x12 hat_x13 hat_x14 hat_x21 hat_x22 hat_x23 hat_x24 hat_x31 hat_x32 hat_x33 hat_x34

X1 = [x11;x12;x13;x14];
X2 = [x21;x22;x23;x24];
X3 = [x31;x32;x33;x34];
Z1 = [z11;z12;z13;z14;z15];
Z2 = [z21;z22;z23;z24;z25];
Z3 = [z31;z32;z33;z34;z35];
y1 = C1*X1;
y2 = C2*X2;
y3 = C3*X3;

hat_X1 = Z1 + H1*y1;
hat_X2 = Z2 + H2*y2;
hat_X3 = Z3 + H3*y3;

% controllers
u1 = -[Kx1 Kf1]* hat_X1;
u2 = -[Kx2 Kf2] * hat_X2;
u3 = -[Kx3 Kf3] * hat_X3;

% observers
dot_Z1 = M1*Z1 + G1*u1 + L1*y1;
dot_Z2 = M2*Z2 + G2*u2 + L2*y2;
dot_Z3 = M3*Z3 + G3*u3 + L3*y3;

% sys dynamic
sigma10 = 67.6/180*pi; sigma20 = 67.7/180*pi; sigma30 = 67.7/180*pi; 
alpha12 = -27.49; alpha13 = -27.49; alpha21 = -23.10; alpha23 = -23.10;  alpha31 = -23.10; alpha32 = -23.10;
gamma12 = cos(0.5*(x11-x21 + 2*(sigma10 - sigma20))); gamma13 = cos(0.5*(x11-x31 + 2*(sigma10 - sigma30))); 
gamma21 = cos(0.5*(x21-x11 + 2*(sigma20 - sigma10))); gamma23 = cos(0.5*(x21-x31 + 2*(sigma20 - sigma30)));
gamma31 = cos(0.5*(x31-x11 + 2*(sigma30 - sigma10))); gamma32 = cos(0.5*(x31-x21 + 2*(sigma30 - sigma20)));
w12 = 0.5*(x11-x21); w13 = 0.5*(x11-x31);
w21 = 0.5*(x21-x11); w23 = 0.5*(x21-x31);
w31 = 0.5*(x31-x11); w32 = 0.5*(x31-x21);

h1 = 0.02*(alpha12*gamma12*sin(w12) + alpha13*gamma13*sin(w13));
h2 = 0.2*(alpha21*gamma21*sin(w21) + alpha23*gamma23*sin(w23));
h3 = 0.2*(alpha31*gamma31*sin(w31) + alpha32*gamma32*sin(w32));

Ms1 = [0; 1; 0; 0];
Ms2 = [0; 1; 0; 0];
Ms3 = [0; 1; 0; 0];

f1 = fa1(t);
f2 = fa2(t);
f3 = fa3(t);

dot_X1 = A1*X1 + B1*u1 + F1*f1 + Ms1*h1;
dot_X2 = A2*X2 + B2*u2 + F2*f2+ Ms2*h2;
dot_X3 = A3*X3 + B3*u3 + F3*f3+ Ms3*h3;


if mod(Int_tmp,6)==0
    Int_count = Int_count + 1;
Int_ts(Int_count) = t;
ff1(Int_count) = f1;
ff2(Int_count) = f2;
ff3(Int_count) = f3;
hat_ff1(Int_count) = hat_X1(5);
hat_ff2(Int_count) = hat_X2(5);
hat_ff3(Int_count) = hat_X3(5);
hat_x11(Int_count) = x11 - hat_X1(1);
hat_x12(Int_count) = x12 - hat_X1(2);
hat_x13(Int_count) = x13 - hat_X1(3);
hat_x14(Int_count) = x14 - hat_X1(4);
hat_x21(Int_count) = x21 - hat_X2(1);
hat_x22(Int_count) = x22 - hat_X2(2);
hat_x23(Int_count) = x23 - hat_X2(3);
hat_x24(Int_count) = x24 - hat_X2(4);
hat_x31(Int_count) = x31 - hat_X3(1);
hat_x32(Int_count) = x32 - hat_X3(2);
hat_x33(Int_count) = x33 - hat_X3(3);
hat_x34(Int_count) = x34 - hat_X3(4);
end
Int_tmp = Int_tmp + 1;

sys_state = [dot_Z1;dot_Z2;dot_Z3;dot_X1;dot_X2;dot_X3];